/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.inventory.IItemHandlerSimpleInserter;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ControllerBlockEntityBase
extends BlockEntity
implements IItemHandlerModifiable {
    private static final int SEARCH_RANGE = 15;
    private List<BlockPos> storagePositions = new ArrayList<BlockPos>();
    private List<Integer> baseIndexes = new ArrayList<Integer>();
    private int totalSlots = 0;
    private final Map<ItemStackKey, Set<BlockPos>> stackStorages = new HashMap<ItemStackKey, Set<BlockPos>>();
    private final Map<BlockPos, Set<ItemStackKey>> storageStacks = new HashMap<BlockPos, Set<ItemStackKey>>();
    private final Set<BlockPos> emptySlotsStorages = new LinkedHashSet<BlockPos>();
    private final Map<Item, Set<BlockPos>> memorizedItemStorages = new HashMap<Item, Set<BlockPos>>();
    private final Map<BlockPos, Set<Item>> storageMemorizedItems = new HashMap<BlockPos, Set<Item>>();

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.stackStorages.clear();
            this.storageStacks.clear();
            this.emptySlotsStorages.clear();
            this.storagePositions.forEach(this::addStorageStacksAndRegisterListeners);
        }
    }

    public void searchAndAddStorages() {
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            positionsToCheck.add(this.m_58899_().m_141952_(dir.m_122436_()));
        }
        this.searchAndAddStorages(positionsToCheck);
    }

    public void changeSlots(BlockPos storagePos, int newSlots, boolean hasEmptySlots) {
        this.updateBaseIndexesAndTotalSlots(storagePos, newSlots);
        this.updateEmptySlots(storagePos, hasEmptySlots);
    }

    private void updateEmptySlots(BlockPos storagePos, boolean hasEmptySlots) {
        if (this.emptySlotsStorages.contains(storagePos) && !hasEmptySlots) {
            this.emptySlotsStorages.remove(storagePos);
        } else if (!this.emptySlotsStorages.contains(storagePos) && hasEmptySlots) {
            this.emptySlotsStorages.add(storagePos);
        }
    }

    private void updateBaseIndexesAndTotalSlots(BlockPos storagePos, int newSlots) {
        int index = this.storagePositions.indexOf(storagePos);
        int originalSlots = this.getStorageSlots(index);
        int diff = newSlots - originalSlots;
        for (int i = index; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) + diff);
        }
        this.totalSlots += diff;
    }

    private int getStorageSlots(int index) {
        int previousBaseIndex = index == 0 ? 0 : this.baseIndexes.get(index - 1);
        return this.baseIndexes.get(index) - previousBaseIndex;
    }

    private void searchAndAddStorages(Set<BlockPos> positionsToCheck) {
        HashSet positionsChecked = new HashSet();
        while (!positionsToCheck.isEmpty()) {
            Iterator<BlockPos> it = positionsToCheck.iterator();
            BlockPos posToCheck = it.next();
            it.remove();
            WorldHelper.getLoadedBlockEntity(this.f_58857_, posToCheck, IControllableStorage.class).ifPresentOrElse(storage -> {
                if (storage.canBeConnected()) {
                    this.addStorageData(posToCheck);
                }
                if (storage.canConnectStorages()) {
                    this.addUncheckedPositionsAround(positionsToCheck, positionsChecked, posToCheck);
                }
            }, () -> positionsChecked.add(posToCheck));
        }
    }

    private void addUncheckedPositionsAround(Set<BlockPos> positionsToCheck, Set<BlockPos> positionsChecked, BlockPos currentPos) {
        for (Direction dir : Direction.values()) {
            BlockPos pos = currentPos.m_141952_(dir.m_122436_());
            if (positionsChecked.contains(pos) || this.storagePositions.contains(pos) || !this.isWithinRange(pos)) continue;
            positionsToCheck.add(pos);
        }
    }

    private boolean isWithinRange(BlockPos pos) {
        return Math.abs(pos.m_123341_() - this.m_58899_().m_123341_()) <= 15 && Math.abs(pos.m_123342_() - this.m_58899_().m_123342_()) <= 15 && Math.abs(pos.m_123343_() - this.m_58899_().m_123343_()) <= 15;
    }

    public void addStorage(BlockPos storagePos) {
        if (this.storagePositions.contains(storagePos)) {
            this.removeStorageInventoryData(storagePos);
        }
        if (this.isWithinRange(storagePos)) {
            HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
            positionsToCheck.add(storagePos);
            this.searchAndAddStorages(positionsToCheck);
        }
    }

    private void addStorageData(BlockPos storagePos) {
        this.storagePositions.add(storagePos);
        this.totalSlots += this.getInventoryHandlerValueFromHolder(storagePos, IItemHandler::getSlots).orElse(0).intValue();
        this.baseIndexes.add(this.totalSlots);
        this.m_6596_();
        this.addStorageStacksAndRegisterListeners(storagePos);
    }

    public void addStorageStacksAndRegisterListeners(BlockPos storagePos) {
        WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).ifPresent(storage -> {
            ITrackedContentsItemHandler handler = storage.getStorageWrapper().getInventoryForInputOutput();
            handler.getTrackedStacks().forEach(k -> this.addStorageStack(storagePos, (ItemStackKey)k));
            if (handler.hasEmptySlots()) {
                this.emptySlotsStorages.add(storagePos);
            }
            storage.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class).getFilterItemSlots().keySet().forEach(i -> this.addStorageMemorizedItem(storagePos, (Item)i));
            storage.registerController(this);
        });
    }

    public void addStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfAbsent(item, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageMemorizedItems.computeIfAbsent(storagePos, pos -> new HashSet()).add(item);
    }

    public void removeStorageMemorizedItem(BlockPos storagePos, Item item) {
        this.memorizedItemStorages.computeIfPresent(item, (i, storagePositions) -> {
            storagePositions.remove(storagePos);
            return storagePositions;
        });
        if (this.memorizedItemStorages.containsKey(item) && this.memorizedItemStorages.get(item).isEmpty()) {
            this.memorizedItemStorages.remove(item);
        }
        this.storageMemorizedItems.remove(storagePos);
    }

    private <T> Optional<T> getInventoryHandlerValueFromHolder(BlockPos storagePos, Function<IItemHandlerSimpleInserter, T> valueGetter) {
        return this.getWrapperValueFromHolder(storagePos, wrapper -> valueGetter.apply(wrapper.getInventoryForInputOutput()));
    }

    private <T> Optional<T> getWrapperValueFromHolder(BlockPos storagePos, Function<IStorageWrapper, T> valueGetter) {
        return WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).map(holder -> valueGetter.apply(holder.getStorageWrapper()));
    }

    public void addStorageStack(BlockPos storagePos, ItemStackKey itemStackKey) {
        this.stackStorages.computeIfAbsent(itemStackKey, stackKey -> new LinkedHashSet()).add(storagePos);
        this.storageStacks.computeIfAbsent(storagePos, pos -> new HashSet()).add(itemStackKey);
    }

    public void removeStorageStack(BlockPos storagePos, ItemStackKey stackKey) {
        this.stackStorages.computeIfPresent(stackKey, (sk, storagePositions) -> {
            storagePositions.remove(storagePos);
            return storagePositions;
        });
        if (this.stackStorages.containsKey(stackKey) && this.stackStorages.get(stackKey).isEmpty()) {
            this.stackStorages.remove(stackKey);
        }
        this.storageStacks.remove(storagePos);
    }

    public void removeStorageStacks(BlockPos storagePos) {
        this.storageStacks.computeIfPresent(storagePos, (pos, stackKeys) -> {
            stackKeys.forEach(stackKey -> {
                Set<BlockPos> storages = this.stackStorages.get(stackKey);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.stackStorages.remove(stackKey);
                    }
                }
            });
            return stackKeys;
        });
        this.storageStacks.remove(storagePos);
    }

    public void removeStorage(BlockPos storagePos) {
        this.removeStorageInventoryDataAndUnregisterController(storagePos);
        this.verifyStoragesConnected();
    }

    private void removeStorageInventoryDataAndUnregisterController(BlockPos storagePos) {
        if (!this.storagePositions.contains(storagePos)) {
            return;
        }
        this.removeStorageInventoryData(storagePos);
        this.m_6596_();
        WorldHelper.getLoadedBlockEntity(this.f_58857_, storagePos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController);
    }

    private void removeStorageInventoryData(BlockPos storagePos) {
        int idx = this.storagePositions.indexOf(storagePos);
        this.totalSlots -= this.getStorageSlots(idx);
        this.removeStorageStacks(storagePos);
        this.removeStorageMemorizedItems(storagePos);
        this.removeStorageWithEmptySlots(storagePos);
        this.storagePositions.remove(idx);
        this.removeBaseIndexAt(idx);
    }

    private void removeStorageMemorizedItems(BlockPos storagePos) {
        this.storageMemorizedItems.computeIfPresent(storagePos, (pos, items) -> {
            items.forEach(item -> {
                Set<BlockPos> storages = this.memorizedItemStorages.get(item);
                if (storages != null) {
                    storages.remove(storagePos);
                    if (storages.isEmpty()) {
                        this.memorizedItemStorages.remove(item);
                    }
                }
            });
            return items;
        });
        this.storageMemorizedItems.remove(storagePos);
    }

    private void verifyStoragesConnected() {
        HashSet<BlockPos> toVerify = new HashSet<BlockPos>(this.storagePositions);
        HashSet<BlockPos> positionsToCheck = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos offsetPos = this.m_58899_().m_141952_(dir.m_122436_());
            if (!toVerify.contains(offsetPos)) continue;
            positionsToCheck.add(offsetPos);
        }
        HashSet<BlockPos> positionsChecked = new HashSet<BlockPos>();
        while (!positionsToCheck.isEmpty()) {
            Iterator it = positionsToCheck.iterator();
            BlockPos posToCheck = (BlockPos)it.next();
            it.remove();
            positionsChecked.add(posToCheck);
            WorldHelper.getLoadedBlockEntity(this.f_58857_, posToCheck, IControllableStorage.class).ifPresent(h -> {
                toVerify.remove(posToCheck);
                if (h.canConnectStorages()) {
                    for (Direction dir : Direction.values()) {
                        BlockPos pos = posToCheck.m_141952_(dir.m_122436_());
                        if (positionsChecked.contains(pos) || !toVerify.contains(pos)) continue;
                        positionsToCheck.add(pos);
                    }
                }
            });
        }
        toVerify.forEach(this::removeStorageInventoryDataAndUnregisterController);
    }

    private void removeBaseIndexAt(int idx) {
        if (idx >= this.baseIndexes.size()) {
            return;
        }
        int slotsRemoved = this.getStorageSlots(idx);
        this.baseIndexes.remove(idx);
        for (int i = idx; i < this.baseIndexes.size(); ++i) {
            this.baseIndexes.set(i, this.baseIndexes.get(i) - slotsRemoved);
        }
    }

    public ControllerBlockEntityBase(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, side);
    }

    public int getSlots() {
        return this.totalSlots;
    }

    private int getIndexForSlot(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndexes.size(); ++i) {
            if (slot - this.baseIndexes.get(i) >= 0) continue;
            return i;
        }
        return -1;
    }

    protected IItemHandlerModifiable getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.storagePositions.size()) {
            return (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        }
        return this.getWrapperValueFromHolder(this.storagePositions.get(index), wrapper -> wrapper.getInventoryForInputOutput()).orElse((IItemHandlerModifiable)EmptyHandler.INSTANCE);
    }

    protected int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndexes.size()) {
            return slot;
        }
        return slot - this.baseIndexes.get(index - 1);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.f_41583_;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "getStackInSlot")) {
            return handler.getStackInSlot(slot);
        }
        return ItemStack.f_41583_;
    }

    private boolean isSlotIndexInvalid(int slot) {
        return slot < 0 || slot >= this.totalSlots;
    }

    private boolean validateHandlerSlotIndex(IItemHandler handler, int handlerIndex, int slot, String methodName) {
        if (slot >= 0 && slot < handler.getSlots()) {
            return true;
        }
        if (handlerIndex < 0 || handlerIndex >= this.storagePositions.size()) {
            SophisticatedCore.LOGGER.debug("Invalid handler index calculated {} in controller's {} method. If you see many of these messages try replacing controller at {}", (Object)handlerIndex, (Object)methodName, (Object)this.m_58899_().m_123344_());
        } else {
            SophisticatedCore.LOGGER.debug("Invalid slot {} passed into controller's {} method for storage at {}. If you see many of these messages try replacing controller at {}", (Object)slot, (Object)methodName, (Object)this.storagePositions.get(handlerIndex).m_123344_(), (Object)this.m_58899_().m_123344_());
        }
        return false;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.isSlotIndexInvalid(slot)) {
            return stack;
        }
        ItemStackKey stackKey = new ItemStackKey(stack);
        ItemStack remaining = stack;
        if (this.stackStorages.containsKey(stackKey)) {
            Set<BlockPos> storagePositions = this.stackStorages.get(stackKey);
            remaining = this.insertIntoStorages(storagePositions, remaining, simulate);
        }
        if (this.memorizedItemStorages.containsKey(stack.m_41720_())) {
            remaining = this.insertIntoStorages(this.memorizedItemStorages.get(stack.m_41720_()), remaining, simulate);
        }
        return this.insertIntoStorages(this.emptySlotsStorages, remaining, simulate);
    }

    private ItemStack insertIntoStorages(Set<BlockPos> positions, ItemStack stack, boolean simulate) {
        ItemStack remaining = stack;
        for (BlockPos storagePos : positions) {
            ItemStack finalRemaining;
            remaining = this.getInventoryHandlerValueFromHolder(storagePos, arg_0 -> ControllerBlockEntityBase.lambda$insertIntoStorages$20(finalRemaining = remaining, simulate, arg_0)).orElse(remaining);
            if (!remaining.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.isSlotIndexInvalid(slot)) {
            return ItemStack.f_41583_;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "extractItem(int slot, int amount, boolean simulate)")) {
            return handler.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return 0;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "getSlotLimit(int slot)")) {
            return handler.getSlotLimit(localSlot);
        }
        return 0;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        int localSlot;
        if (this.isSlotIndexInvalid(slot)) {
            return false;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, localSlot = this.getSlotFromIndex(slot, handlerIndex), "isItemValid(int slot, ItemStack stack)")) {
            return handler.isItemValid(localSlot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (this.isSlotIndexInvalid(slot)) {
            return;
        }
        int handlerIndex = this.getIndexForSlot(slot);
        IItemHandlerModifiable handler = this.getHandlerFromIndex(handlerIndex);
        if (this.validateHandlerSlotIndex((IItemHandler)handler, handlerIndex, slot = this.getSlotFromIndex(slot, handlerIndex), "setStackInSlot(int slot, ItemStack stack)")) {
            handler.setStackInSlot(slot, stack);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.detachFromStorages();
    }

    public void detachFromStorages() {
        this.storagePositions.forEach(pos -> WorldHelper.getLoadedBlockEntity(this.f_58857_, pos, IControllableStorage.class).ifPresent(IControllableStorage::unregisterController));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NBTHelper.putList(tag, "storagePositions", this.storagePositions, p -> LongTag.m_128882_((long)p.m_121878_()));
        NBTHelper.putList(tag, "baseIndexes", this.baseIndexes, IntTag::m_128679_);
        tag.m_128405_("totalSlots", this.totalSlots);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storagePositions = NBTHelper.getCollection(tag, "storagePositions", (byte)4, t -> Optional.of(BlockPos.m_122022_((long)((LongTag)t).m_7046_())), ArrayList::new).orElse(new ArrayList());
        this.baseIndexes = NBTHelper.getCollection(tag, "baseIndexes", (byte)3, t -> Optional.of(((IntTag)t).m_7047_()), ArrayList::new).orElse(new ArrayList());
        this.totalSlots = tag.m_128451_("totalSlots");
    }

    public void addStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.add(storageBlockPos);
    }

    public void removeStorageWithEmptySlots(BlockPos storageBlockPos) {
        this.emptySlotsStorages.remove(storageBlockPos);
    }

    private static /* synthetic */ ItemStack lambda$insertIntoStorages$20(ItemStack finalRemaining, boolean simulate, IItemHandlerSimpleInserter ins) {
        return ins.insertItem(finalRemaining, simulate);
    }
}

